/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.mediasvc.DeviceClassProperties;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameterKeys;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameters;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

abstract class MediaDeviceProperties
implements MediaServicesErrorIds,
MediaServicesParameterKeys {
    private static final String TRACE_MASKT = "XMDAMDPT";
    private static final String TRACE_MASKF = "XMDAMDPF";
    private static final String TRACE_MASKD = "XMDAMDPD";
    private DeviceClassProperties deviceClassProperties;
    private String internalName;
    private LocalizableText displayableName;
    private LocalizableText displayableDescription;
    private boolean preferred;
    protected String mountPoint;
    protected String deviceFile;
    protected String deviceFileSymLink;
    MediaServicesParameters mediaServicesParameters;
    protected final String DEVICE_FILE_SCRIPT = "media.device.file.script";
    protected static final String FSTAB_FILE = "/etc/fstab";

    MediaDeviceProperties(DeviceClassProperties deviceClassProperties) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.MediaDeviceProperties(DeviceClassProperties = " + deviceClassProperties + ")");
        this.deviceClassProperties = deviceClassProperties;
        this.preferred = false;
        this.mediaServicesParameters = MediaServicesParameters.getMediaServicesParameters();
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.MediaDeviceProperties()");
    }

    void setInternalName() {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.setInternalName()");
        this.internalName = this.mountPoint.substring(this.mountPoint.lastIndexOf("/") + 1);
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.setInternalName()");
    }

    void setDisplayableName(LocalizableText displayableName) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.setDisplayableName(displayableName = " + displayableName.toString() + ")");
        this.displayableName = displayableName;
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.setDisplayableName()");
    }

    void setDisplayableDescription(LocalizableText displayableDescription) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.setDisplayableDescription(displayableDescription = " + displayableDescription.toString() + ")");
        this.displayableDescription = displayableDescription;
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.setDisplayableDescription()");
    }

    abstract void setMountPoint(String var1);

    abstract void setDeviceFile(String var1) throws MediaDeviceException;

    void setPreferred(boolean preferred) {
        Trace.trace(TRACE_MASKT, "-> MediaDeviceProperties.setPreferred(" + preferred + ")");
        this.preferred = preferred;
        Trace.trace(TRACE_MASKT, "<- MediaDeviceProperties.setPreferred()");
    }

    String getInternalName() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getInternalName(): returns " + this.internalName);
        return this.internalName;
    }

    LocalizableText getDisplayableName() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDisplayableName(): returns " + this.displayableName);
        return this.displayableName;
    }

    LocalizableText getDisplayableDescription() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDisplayableDescription(): returns " + this.displayableDescription);
        return this.displayableDescription;
    }

    String getMountPoint() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getMountPoint(): returns " + this.mountPoint);
        return this.mountPoint;
    }

    String getDeviceFile() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDeviceFile(): returns " + this.deviceFile);
        return this.deviceFile;
    }

    int[] getMediaSupported() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getMediaSupported()");
        return this.deviceClassProperties.getMediaSupported();
    }

    int[] getFileSystems() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getFileSystems()");
        return this.deviceClassProperties.getFileSystems();
    }

    String getLabelScript() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getLabelScript(): returns " + this.deviceClassProperties.getLabelScript());
        return this.deviceClassProperties.getLabelScript();
    }

    String getDosDrive() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDosDrive(): returns " + this.deviceClassProperties.getDosDrive());
        return this.deviceClassProperties.getDosDrive();
    }

    String getDeviceType() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.getDeviceType(): returns " + this.deviceClassProperties.getDeviceType());
        return this.deviceClassProperties.getDeviceType();
    }

    boolean isEjectable() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isEjectable(): returns " + this.deviceClassProperties.isEjectable());
        return this.deviceClassProperties.isEjectable();
    }

    boolean isLockable() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isLockable(): returns " + this.deviceClassProperties.isLockable());
        return this.deviceClassProperties.isLockable();
    }

    boolean isFormattable() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isFormattable(): returns " + this.deviceClassProperties.isFormattable());
        return this.deviceClassProperties.isFormattable();
    }

    boolean isReadOnly() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isReadOnly(): returns " + this.deviceClassProperties.isReadOnly());
        return this.deviceClassProperties.isReadOnly();
    }

    boolean isMassWritable() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isMassWritable(): returns " + this.deviceClassProperties.isMassWritable());
        return this.deviceClassProperties.isMassWritable();
    }

    boolean isMassReadOnly() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isMassReadOnly(): returns " + this.deviceClassProperties.isMassReadOnly());
        return this.deviceClassProperties.isMassReadOnly();
    }

    boolean isMediaSupported(int mediaType) {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isMediaSupported(mediaType = " + mediaType + ")");
        return this.deviceClassProperties.isMediaSupported(mediaType);
    }

    boolean isPreferred() {
        Trace.trace(TRACE_MASKT, "<> MediaDeviceProperties.isPreferred(): returns " + this.preferred);
        return this.preferred;
    }
}

